package com.ejie.aa17a.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa17a.model.Aa17aRegistroMaestro;
import com.ejie.aa17a.service.iface.Aa17aRegistroMaestroService;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;

/**
 * Aa17aRegistroMaestroController generated by UDA, 18-dic-2013 15:36:30.
 * 
 * @author UDA
 */

@RequestMapping(value = "/aa17aregistromaestro")
public class Aa17aRegistroMaestroController {

	private static final Logger logger = LoggerFactory.getLogger(Aa17aRegistroMaestroController.class);

	private Aa17aRegistroMaestroService aa17aRegistroMaestroService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		Aa17aRegistroMaestroController.logger.info("[GET - View] : aa17aregistromaestro");
		return "aa17aregistromaestro";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idRegistro
	 *            Long
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaBaja
	 *            Date
	 * @param idPadre
	 *            Long
	 * @param idAbuelo
	 *            Long
	 * @return aa17aRegistroMaestro Aa17aRegistroMaestro
	 */
	@RequestMapping(value = "/{idRegistro}/{descripcionCastellano}/{descripcionEuskera}/{fechaBaja}/{idPadre}/{idAbuelo}", method = RequestMethod.GET)
	public @ResponseBody
	Aa17aRegistroMaestro getById(@PathVariable Long idRegistro, @PathVariable String descripcionCastellano, @PathVariable String descripcionEuskera, @PathVariable Date fechaBaja, @PathVariable Long idPadre, @PathVariable Long idAbuelo) {
		Aa17aRegistroMaestro aa17aRegistroMaestro = new Aa17aRegistroMaestro();
		aa17aRegistroMaestro.setIdRegistro(idRegistro);
		aa17aRegistroMaestro.setDescripcionCastellano(descripcionCastellano);
		aa17aRegistroMaestro.setDescripcionEuskera(descripcionEuskera);
		aa17aRegistroMaestro.setFechaBaja(fechaBaja);
		aa17aRegistroMaestro.setIdPadre(idPadre);
		aa17aRegistroMaestro.setIdAbuelo(idAbuelo);
		aa17aRegistroMaestro = this.aa17aRegistroMaestroService.find(aa17aRegistroMaestro);
		Aa17aRegistroMaestroController.logger.info("[GET - findBy_PK] : Obtener Aa17aRegistroMaestro por PK");
		return aa17aRegistroMaestro;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterAa17aRegistroMaestro
	 *            Aa17aRegistroMaestro
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa17aRegistroMaestro> getAll(@ModelAttribute Aa17aRegistroMaestro filterAa17aRegistroMaestro) {
		Aa17aRegistroMaestroController.logger.info("[GET - find_ALL] : Obtener Aa17aRegistroMaestro por filtro");
		return this.aa17aRegistroMaestroService.findAll(filterAa17aRegistroMaestro, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param aa17aRegistroMaestro
	 *            Aa17aRegistroMaestro
	 * @return Aa17aRegistroMaestro
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa17aRegistroMaestro edit(@RequestBody Aa17aRegistroMaestro aa17aRegistroMaestro) {
		Aa17aRegistroMaestro aa17aRegistroMaestroAux = this.aa17aRegistroMaestroService.update(aa17aRegistroMaestro);
		Aa17aRegistroMaestroController.logger.info("[PUT] : Aa17aRegistroMaestro actualizado correctamente");
		return aa17aRegistroMaestroAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param aa17aRegistroMaestro
	 *            Aa17aRegistroMaestro
	 * @return Aa17aRegistroMaestro
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa17aRegistroMaestro add(@RequestBody Aa17aRegistroMaestro aa17aRegistroMaestro) {
		Aa17aRegistroMaestro aa17aRegistroMaestroAux = this.aa17aRegistroMaestroService.add(aa17aRegistroMaestro);
		Aa17aRegistroMaestroController.logger.info("[POST] : Aa17aRegistroMaestro insertado correctamente");
		return aa17aRegistroMaestroAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idRegistro
	 *            Long
	 * @param descripcionCastellano
	 *            String
	 * @param descripcionEuskera
	 *            String
	 * @param fechaBaja
	 *            Date
	 * @param idPadre
	 *            Long
	 * @param idAbuelo
	 *            Long
	 * @return aa17aRegistroMaestro
	 */
	@RequestMapping(value = "/{idRegistro}/{descripcionCastellano}/{descripcionEuskera}/{fechaBaja}/{idPadre}/{idAbuelo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa17aRegistroMaestro remove(@PathVariable Long idRegistro, @PathVariable String descripcionCastellano, @PathVariable String descripcionEuskera, @PathVariable Date fechaBaja, @PathVariable Long idPadre, @PathVariable Long idAbuelo) {
		Aa17aRegistroMaestro aa17aRegistroMaestro = new Aa17aRegistroMaestro();
		aa17aRegistroMaestro.setIdRegistro(idRegistro);
		aa17aRegistroMaestro.setDescripcionCastellano(descripcionCastellano);
		aa17aRegistroMaestro.setDescripcionEuskera(descripcionEuskera);
		aa17aRegistroMaestro.setFechaBaja(fechaBaja);
		aa17aRegistroMaestro.setIdPadre(idPadre);
		aa17aRegistroMaestro.setIdAbuelo(idAbuelo);
		this.aa17aRegistroMaestroService.remove(aa17aRegistroMaestro);
		Aa17aRegistroMaestroController.logger.info("[DELETE] : Aa17aRegistroMaestro borrado correctamente");
		return aa17aRegistroMaestro;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param aa17aRegistroMaestroIds
	 *            List
	 * @return aa17aRegistroMaestroList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(@RequestBody List<List<String>> aa17aRegistroMaestroIds) {
		List<Aa17aRegistroMaestro> aa17aRegistroMaestroList = new ArrayList<Aa17aRegistroMaestro>();
		for (List<String> aa17aRegistroMaestroId : aa17aRegistroMaestroIds) {
			Iterator<String> iterator = aa17aRegistroMaestroId.iterator();
			Aa17aRegistroMaestro aa17aRegistroMaestro = new Aa17aRegistroMaestro(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
			aa17aRegistroMaestro.setIdRegistro(ObjectConversionManager.convert(iterator.next(), Long.class));
			aa17aRegistroMaestro.setDescripcionCastellano(ObjectConversionManager.convert(iterator.next(), String.class));
			aa17aRegistroMaestro.setDescripcionEuskera(ObjectConversionManager.convert(iterator.next(), String.class));
			aa17aRegistroMaestro.setFechaBaja(ObjectConversionManager.convert(iterator.next(), java.util.Date.class));
			aa17aRegistroMaestro.setIdPadre(ObjectConversionManager.convert(iterator.next(), Long.class));
			aa17aRegistroMaestro.setIdAbuelo(ObjectConversionManager.convert(iterator.next(), Long.class));
			aa17aRegistroMaestroList.add(aa17aRegistroMaestro);
		}
		this.aa17aRegistroMaestroService.removeMultiple(aa17aRegistroMaestroList);
		Aa17aRegistroMaestroController.logger.info("[POST - DELETE_ALL] : Aa17aRegistroMaestro borrados correctamente");
		return aa17aRegistroMaestroIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterAa17aRegistroMaestro
	 *            Aa17aRegistroMaestro
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Aa17aRegistroMaestro filterAa17aRegistroMaestro, @ModelAttribute Pagination pagination) {
		List<Aa17aRegistroMaestro> aa17aRegistroMaestros = this.aa17aRegistroMaestroService.findAll(filterAa17aRegistroMaestro, pagination);
		Long recordNum = this.aa17aRegistroMaestroService.findAllCount(filterAa17aRegistroMaestro);
		Aa17aRegistroMaestroController.logger.info("[GET - jqGrid] : Obtener Aa17aRegistroMaestro");
		return new JQGridJSONModel(pagination, recordNum, aa17aRegistroMaestros);
	}

	/**
	 * Method 'setAa17aRegistroMaestroService'.
	 * 
	 * @param aa17aRegistroMaestroService
	 *            Aa17aRegistroMaestroService
	 * @return
	 */
	public void setAa17aRegistroMaestroService(Aa17aRegistroMaestroService aa17aRegistroMaestroService) {
		this.aa17aRegistroMaestroService = aa17aRegistroMaestroService;
	}
}
